﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Net
Imports System.Data


Public Class MainForm

    Const DataRetrievalError As String = _
        "An error occurred trying to retrieve the data from the Web Service." & _
        "The Web service may currently be down. You might attempt to access " & _
        "it directly: "


    '调用 EuroConvert Web 服务以获取一个数据集，该数据集包括所有可从
    '欧元转换的币种。然后，将该数据集
    '绑定到 ComboBox，以便在“Currency”（货币）选项卡上使用。
    Private Sub LoadCurrencyConverterComboBox()
        '根据 XML 文档创建并填充数据集。
        Dim dsCountries As New DataSet()

        Try
            dsCountries.ReadXml(New System.IO.StringReader(My.Resources.ecc_countries))
        Catch exp As Exception
            MsgBox("Error loading DataSet from XML: ", MsgBoxStyle.OKOnly, Me.Text)
            Exit Sub
        End Try

        '将该数据集绑定到 ComboBox 以进行显示。
        With cboConvertTo
            .DataSource = dsCountries.Tables(0)
            .DisplayMember = "Description"
            .ValueMember = "Currency"
        End With
    End Sub


    '关闭 ShowStatusIndicators() 激活的状态指示器。
    Private Sub ResetStatusIndicators()
        '重置状态指示器，无论发生什么情况。
        Me.Cursor = Cursors.Default
        'frmStatus.Hide()
    End Sub

    '显示各种 Web 服务连接和用于 UI
    '反馈的数据状态指示器。
    Private Sub ShowStatusIndicators()
        '显示相应光标。确保调用 DoEvents()，
        '否则此代码在整个 Click 事件处理完毕以前不会运行，处理过程中
        '光标将不起作用（甚至不可见）。
        Me.Cursor = Cursors.WaitCursor
        Application.DoEvents()
    End Sub

    '处理“Currency”（货币）选项卡的“Convert”（转换）按钮单击事件。此事件处理程序
    '连接 Web 服务，传递币种转换的
    '源币种国家/地区和目标币种国家/地区，并
    '返回汇率。然后，使用汇率来计算最后的值。
    Private Sub btnConvert_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnConvert.Click

        '创建一个 Web 服务代理类的实例。
        Dim wsEuroConverter As New WebServiceClient.ConvertEuros.IEuroservice

        ShowStatusIndicators()

        '从 Web 服务检索数据。
        Try
            lblConvertedAmount.Text = wsEuroConverter.FromEuro(cboConvertTo.SelectedValue.ToString, CLng(txtAmount.Text)).ToString
        Catch exp As Exception
            MessageBox.Show(DataRetrievalError & _
                wsEuroConverter.Url, _
                "Web Service Demo Error", _
                MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        Finally
            ResetStatusIndicators()
        End Try
    End Sub

    '处理“Diblert”选项卡的“Get Cartoon!”（获取卡通！）按钮单击事件。
    Private Sub btnCartoon_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCartoon.Click

        '创建一个 Web 服务代理类的实例。
        Dim wsDailyDiblert As New WebServiceClient.DailyDiblert.DailyDilbert

        '显示状态窗体，这样，就不会将访问 Web
        '服务引起的延迟误解为未正确加载窗体或存在其他
        '问题。
        ShowStatusIndicators()

        '从 Web 服务检索数据。Web 服务还公开一个
        '返回图像 Url 的方法，但在此使用该方法
        '没有意义。
        Try
            '异步调用 Web 方法。
            wsDailyDiblert.DailyDilbertImageAsync()
            AddHandler wsDailyDiblert.DailyDilbertImageCompleted, AddressOf DiblertCompleted
        Catch exp As Exception
            MessageBox.Show(DataRetrievalError & _
                wsDailyDiblert.Url, _
                "Web Service Demo Error", _
                MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        Finally
            '隐藏状态窗体，无论检索卡通还是发生
            '错误。
            ResetStatusIndicators()
        End Try
    End Sub

    Sub DiblertCompleted(ByVal sender As Object, ByVal e As WebServiceClient.DailyDiblert.DailyDilbertImageCompletedEventArgs)
        Try
            Dim ms As New System.IO.MemoryStream(e.Result)

            '通过对 FromStream 方法的简单调用，在PictureBox 控件中
            '显示。
            With picDilbert
                .Image = Image.FromStream(ms)
                .SizeMode = PictureBoxSizeMode.CenterImage
                .BorderStyle = BorderStyle.Fixed3D
            End With
        Catch ex As Exception
            MessageBox.Show("The cartoon was not retrieved in the " & _
                "time you specified.", "Web Service Demo Information", _
                MessageBoxButtons.OK, MessageBoxIcon.Information)
        End Try
    End Sub

    '处理“Books”（图书）选项卡的“Get Data”（获取数据）按钮单击事件。此事件处理程序连接
    'SalesRankNPrice Web 服务，并下载 Amazon 和 Barnes & Noble
    '销售排行以及按照 ISBN 编号给出的图书的价格。
    Private Sub btnGetBookData_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetBookData.Click

        '创建 Web 服务代理类和 All 类的一个实例，
        'All 类也由 Web 服务提供，作为一种方便类型来保存
        'GetAll 方法返回的数据。
        Dim salesRank As New WebServiceClient.BandN.BNPrice
        Dim price As String

        ShowStatusIndicators()

        '从 Web 服务检索数据。
        Try
            price = salesRank.GetBNQuote(txtISBN.Text)
        Catch exp As Exception
            MsgBox(DataRetrievalError & salesRank.Url, MsgBoxStyle.OKOnly, Me.Text)
            Exit Sub
        Finally
            '重置状态指示器，无论发生什么情况。
            ResetStatusIndicators()
        End Try

        '创建一个 ListViewItem 对象，并设置第一列的文本。
        Dim lvItem As New ListViewItem()
        lvItem.Text = txtISBN.Text

        '设置其余各列的文本，并将 ListViewItem 对象
        '添加到 ListView。
        With lvItem.SubItems
            .Add(price)
        End With
        lvwBooks.Items.Add(lvItem)
    End Sub

    '处理“Local Time”（本地时间）选项卡的“Get Time”（获取时间）按钮单击事件。此事件处理程序
    '连接“Local Time”Web 服务，并下载给定邮政编码所对应的
    '日期和时间。
    Private Sub btnGetTime_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetTime.Click

        '创建一个 Web 服务代理类的实例。
        Dim wsLocalTime As New WebServiceClient.LocalTime.LocalTime

        ShowStatusIndicators()

        Try
            '从该 Web 服务检索时间。
            lblTime.Text = wsLocalTime.LocalTimeByZipCode(txtZipCodeForTime.Text)
        Catch exp As Exception
            MsgBox(DataRetrievalError & wsLocalTime.Url, MsgBoxStyle.OkOnly, Me.Text)
            Exit Sub
        Finally
            '重置状态指示器，无论发生什么情况。
            ResetStatusIndicators()
        End Try

    End Sub


    '处理相应窗体的加载事件，该事件绑定一个在“Currency”（货币）
    '选项卡上使用的 ComboBox。
    Private Sub frmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        LoadCurrencyConverterComboBox()
    End Sub


    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class
